
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")

    # Set objective function
    m.setObjective(5.48 * vitamin_d + 3.41 * vitamin_e + 3.37 * vitamin_b2 + 9.6 * calcium, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.34 * vitamin_d + 0.07 * vitamin_e + 1.3 * vitamin_b2 + 0.95 * calcium <= 155, "r0_upper_bound")
    m.addConstr(0.07 * vitamin_e + 0.95 * calcium >= 19, "c1")
    m.addConstr(0.07 * vitamin_e + 1.3 * vitamin_b2 >= 21, "c2")
    m.addConstr(1.34 * vitamin_d + 1.3 * vitamin_b2 >= 23, "c3")
    m.addConstr(0.07 * vitamin_e + 1.3 * vitamin_b2 + 0.95 * calcium >= 19, "c4")
    m.addConstr(1.34 * vitamin_d + 0.07 * vitamin_e + 0.95 * calcium >= 19, "c5")
    m.addConstr(1.34 * vitamin_d + 0.07 * vitamin_e + 0.95 * calcium >= 19, "c6") # Duplicate constraint removed
    m.addConstr(1.34 * vitamin_d + 0.07 * vitamin_e + 1.3 * vitamin_b2 + 0.95 * calcium >= 19, "c7")
    m.addConstr(-3 * vitamin_e + 9 * calcium >= 0, "c8")
    m.addConstr(-1 * vitamin_e + 9 * vitamin_b2 >= 0, "c9")
    m.addConstr(9 * vitamin_d - 5 * vitamin_e >= 0, "c10")
    m.addConstr(1.34 * vitamin_d + 0.95 * calcium <= 45, "c11")
    m.addConstr(1.34 * vitamin_d + 1.3 * vitamin_b2 + 0.95 * calcium <= 107, "c12")
    m.addConstr(1.34 * vitamin_d + 0.07 * vitamin_e + 0.95 * calcium <= 121, "c13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
