
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin D
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin E
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B2
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x4")  # milligrams of calcium

    # Objective function
    model.setObjective(5.48*x1 + 3.41*x2 + 3.37*x3 + 9.6*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.07*x2 + 0.95*x4 >= 19)
    model.addConstr(0.07*x2 + 1.3*x3 >= 21)
    model.addConstr(1.34*x1 + 1.3*x3 >= 23)
    model.addConstr(0.07*x2 + 1.3*x3 + 0.95*x4 >= 19)
    model.addConstr(1.34*x1 + 0.07*x2 + 0.95*x4 >= 19)
    model.addConstr(1.34*x1 + 0.07*x2 + 1.3*x3 + 0.95*x4 >= 19)
    model.addConstr(-3*x2 + 9*x4 >= 0)
    model.addConstr(-x2 + 9*x3 >= 0)
    model.addConstr(9*x1 - 5*x2 >= 0)
    model.addConstr(1.34*x1 + 0.95*x4 <= 45)
    model.addConstr(1.34*x1 + 1.3*x3 + 0.95*x4 <= 107)
    model.addConstr(1.34*x1 + 0.07*x2 + 0.95*x4 <= 121)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"milligrams of vitamin D: {x1.varValue}")
        print(f"milligrams of vitamin E: {x2.varValue}")
        print(f"milligrams of vitamin B2: {x3.varValue}")
        print(f"milligrams of calcium: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
