
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # grams of fat
x1 = m.addVar(name="x1", lb=0)  # milligrams of potassium
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin C
x3 = m.addVar(name="x3", lb=0)  # milligrams of calcium

# Objective function
m.setObjective(3*x0 + 3*x1 + 7*x2 + x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(17*x0 <= 454)
m.addConstr(19*x0 <= 235)
m.addConstr(16*x0 <= 527)
m.addConstr(9*x0 <= 397)

m.addConstr(16*x1 <= 454)
m.addConstr(16*x1 <= 235)
m.addConstr(7*x1 <= 527)
m.addConstr(16*x1 <= 397)

m.addConstr(15*x2 <= 454)
m.addConstr(19*x2 <= 235)
m.addConstr(8*x2 <= 527)
m.addConstr(3*x2 <= 397)

m.addConstr(2*x3 <= 454)
m.addConstr(18*x3 <= 235)
m.addConstr(6*x3 <= 527)
m.addConstr(17*x3 <= 397)

m.addConstr(17*x0 + 2*x3 >= 55)
m.addConstr(16*x1 + 2*x3 >= 62)
m.addConstr(19*x0 + 18*x3 >= 48)
m.addConstr(19*x2 + 18*x3 >= 37)
m.addConstr(19*x0 + 16*x1 + 18*x3 >= 41)
m.addConstr(19*x0 + 16*x1 + 19*x2 >= 41)

m.addConstr(9*x0 + 3*x2 >= 57)
m.addConstr(9*x0 + 16*x1 >= 57)
m.addConstr(16*x1 + 3*x2 >= 68)
m.addConstr(3*x2 + 17*x3 >= 40)

m.addConstr(6*x0 + 8*x2 - 4*x3 >= 0)

m.addConstr(15*x2 + 2*x3 <= 360)
m.addConstr(17*x0 + 16*x1 <= 446)
m.addConstr(17*x0 + 2*x3 <= 335)
m.addConstr(17*x0 + 15*x2 + 2*x3 <= 316)
m.addConstr(17*x0 + 16*x1 + 15*x2 + 2*x3 <= 316)

m.addConstr(19*x2 + 18*x3 <= 140)
m.addConstr(19*x0 + 16*x1 <= 118)
m.addConstr(16*x1 + 19*x2 <= 86)
m.addConstr(19*x0 + 16*x1 + 19*x2 + 18*x3 <= 86)

m.addConstr(16*x0 + 8*x2 <= 405)
m.addConstr(7*x1 + 6*x3 <= 289)
m.addConstr(7*x1 + 8*x2 <= 448)
m.addConstr(16*x0 + 7*x1 <= 427)
m.addConstr(16*x0 + 6*x3 <= 481)
m.addConstr(16*x0 + 7*x1 + 8*x2 + 6*x3 <= 481)

m.addConstr(9*x0 + 17*x3 <= 283)
m.addConstr(16*x1 + 3*x2 <= 332)
m.addConstr(9*x0 + 16*x1 <= 173)
m.addConstr(16*x1 + 17*x3 <= 383)
m.addConstr(16*x1 + 3*x2 + 17*x3 <= 361)
m.addConstr(9*x0 + 16*x1 + 3*x2 + 17*x3 <= 361)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
