
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="peanutbutter sandwiches")  # peanutbutter sandwiches
    x1 = m.addVar(name="lemons")  # lemons
    x2 = m.addVar(name="slices of pizza")  # slices of pizza


    # Set objective function
    m.setObjective(3*x0*x1 + 4*x2**2 + x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.84*x0 + 12.6*x2 >= 32, "tastiness_constraint1")
    m.addConstr(4.98*x1 + 12.6*x2 >= 20, "tastiness_constraint2")
    m.addConstr(1.84*x0 + 4.98*x1 >= 18, "tastiness_constraint3")
    m.addConstr(1.84*x0 + 4.98*x1 + 12.6*x2 >= 18, "tastiness_constraint4")
    m.addConstr(3.49*x0 + 7.75*x2 >= 35, "healthiness_constraint1")
    m.addConstr(3.39*x1 + 7.75*x2 >= 40, "healthiness_constraint2")
    m.addConstr(3.49*x0 + 3.39*x1 + 7.75*x2 >= 26, "healthiness_constraint3")
    m.addConstr(6*x0 - 10*x2 >= 0, "constraint1")
    m.addConstr(9*x1 - 7*x2 >= 0, "constraint2")
    m.addConstr((3.39*x1)**2 + (7.75*x2)**2 <= 95, "healthiness_constraint_squared")
    m.addConstr(3.49*x0 + 3.39*x1 <= 63, "healthiness_constraint4")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
