
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="peanutbutter_sandwiches", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="lemons", lb=-gurobi.GRB.INFINITY)
    x3 = model.addVar(name="slices_of_pizza", lb=-gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3*x1*x2 + 4*x3**2 + x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1.84*x1 + 12.6*x3 >= 32)
    model.addConstr(4.98*x2 + 12.6*x3 >= 20)
    model.addConstr(1.84*x1 + 4.98*x2 >= 18)
    model.addConstr(1.84*x1 + 4.98*x2 + 12.6*x3 >= 18)
    model.addConstr(3.49*x1 + 7.75*x3 >= 35)
    model.addConstr(3.39*x2 + 7.75*x3 >= 40)
    model.addConstr(3.49*x1 + 3.39*x2 + 7.75*x3 >= 26)
    # Duplicate constraint, remove if intended
    # model.addConstr(3.49*x1 + 3.39*x2 + 7.75*x3 >= 26)
    model.addConstr(6*x1 - 10*x3 >= 0)
    model.addConstr(9*x2 - 7*x3 >= 0)
    model.addConstr(3.39**2*x2**2 + 7.75**2*x3**2 <= 95)
    model.addConstr(3.49*x1 + 3.39*x2 <= 63)

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Peanutbutter sandwiches: ", x1.x)
        print("Lemons: ", x2.x)
        print("Slices of pizza: ", x3.x)
    else:
        print("The model is infeasible")

optimize_problem()
