
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="hours_worked_by_George")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Bill")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Laura")


# Set objective function
m.setObjective(8*x0**2 + 8*x0*x1 + 8*x0*x2 + 9*x1**2 + 6*x1*x2 + x2**2 + 3*x0 + 4*x1 + 5*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1**2 + 22*x2**2 >= 64)
m.addConstr(26*x0 + 3*x1 + 22*x2 >= 64)
m.addConstr(15*x1 + 12*x2 >= 16)
m.addConstr(5*x0**2 + 12*x2**2 >= 37)
m.addConstr(5*x0 + 15*x1 + 12*x2 >= 37)
m.addConstr(20*x0**2 + 19*x2**2 >= 77)
m.addConstr(20*x0 + 24*x1 >= 74)
m.addConstr(20*x0 + 24*x1 + 19*x2 >= 74)
m.addConstr(x0 + 23*x1 >= 29)
m.addConstr(23*x1 + 29*x2 >= 61)
m.addConstr(x0**2 + 23*x1**2 + 29*x2**2 >= 72)
m.addConstr(x0 + 23*x1 + 29*x2 >= 72)
m.addConstr(3*x0 + 3*x2 >= 58)
m.addConstr(12*x1 + 3*x2 >= 54)
m.addConstr(3*x0 + 12*x1 + 3*x2 >= 54)
m.addConstr(10*x0**2 - 8*x2**2 >= 0)
m.addConstr(9*x0 - 4*x1 >= 0)
m.addConstr(26*x0 + 3*x1 <= 111)
m.addConstr(5*x0 + 12*x2 <= 115)
m.addConstr(12*x1 + 3*x2 <= 111)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

