
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by George
x1 = m.addVar(name="x1")  # hours worked by Bill
x2 = m.addVar(name="x2")  # hours worked by Laura

# Define the objective function
m.setObjective(8*x0**2 + 8*x0*x1 + 8*x0*x2 + 9*x1**2 + 6*x1*x2 + x2**2 + 3*x0 + 4*x1 + 5*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(26*x0 <= 200)
m.addConstr(5*x0 <= 138)
m.addConstr(20*x0 <= 233)
m.addConstr(x0 <= 219)
m.addConstr(3*x0 <= 198)

m.addConstr(3*x1 <= 200)
m.addConstr(15*x1 <= 138)
m.addConstr(24*x1 <= 233)
m.addConstr(23*x1 <= 219)
m.addConstr(12*x1 <= 198)

m.addConstr(22*x2 <= 200)
m.addConstr(12*x2 <= 138)
m.addConstr(19*x2 <= 233)
m.addConstr(29*x2 <= 219)
m.addConstr(3*x2 <= 198)

m.addConstr(3*x1**2 + 22*x2**2 >= 64)
m.addConstr(26*x0 + 3*x1 + 22*x2 >= 64)
m.addConstr(15*x1 + 12*x2 >= 16)
m.addConstr(5*x0**2 + 12*x2**2 >= 37)
m.addConstr(5*x0 + 15*x1 + 12*x2 >= 37)
m.addConstr(20*x0**2 + 19*x2**2 >= 77)
m.addConstr(20*x0 + 24*x1 >= 74)
m.addConstr(20*x0 + 24*x1 + 19*x2 >= 74)
m.addConstr(x0 + 23*x1 >= 29)
m.addConstr(23*x1 + 29*x2 >= 61)
m.addConstr(x0**2 + 23*x1**2 + 29*x2**2 >= 72)
m.addConstr(x0 + 23*x1 + 29*x2 >= 72)
m.addConstr(3*x0 + 3*x2 >= 58)
m.addConstr(12*x1 + 3*x2 >= 54)
m.addConstr(3*x0 + 12*x1 + 3*x2 >= 54)
m.addConstr(10*x0**2 - 8*x2**2 >= 0)
m.addConstr(9*x0 - 4*x1 >= 0)
m.addConstr(26*x0 + 3*x1 <= 111)
m.addConstr(5*x0 + 12*x2 <= 115)
m.addConstr(12*x1 + 3*x2 <= 111)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
