
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hamburgers")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")


# Set objective function
m.setObjective(8.94*chicken_thighs*bagged_salads + 3.49*chicken_thighs*granola_bars + 6.96*bagged_salads**2 + 1.22*bagged_salads*corn_cobs + 5.04*hamburgers*granola_bars + 9.86*hamburgers + 1.62*corn_cobs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*chicken_thighs + 5*bagged_salads + 1*hamburgers + 2*granola_bars + 2*corn_cobs <= 214, "c0")
m.addConstr(hamburgers**2 + granola_bars**2 >= 31, "c1")
m.addConstr(5*chicken_thighs + 5*bagged_salads >= 24, "c2")
m.addConstr(5*chicken_thighs + 2*granola_bars >= 24, "c3")
m.addConstr(5*bagged_salads + 2*corn_cobs >= 23, "c4")
m.addConstr(1*hamburgers + 2*corn_cobs >= 17, "c5")
m.addConstr(5*bagged_salads + 2*granola_bars >= 39, "c6")
m.addConstr(5*chicken_thighs + 1*hamburgers + 2*corn_cobs >= 21, "c7")
m.addConstr(25*chicken_thighs**2 + 25*bagged_salads**2 + 4*corn_cobs**2 >= 21, "c8")
m.addConstr(1*hamburgers + 2*granola_bars + 2*corn_cobs >= 21, "c9")
m.addConstr(5*chicken_thighs + 1*hamburgers + 2*corn_cobs >= 29, "c10")
m.addConstr(5*chicken_thighs + 5*bagged_salads + 2*corn_cobs >= 29, "c11")
m.addConstr(1*hamburgers + 2*granola_bars + 2*corn_cobs >= 29, "c12")
m.addConstr(25*chicken_thighs**2 + 1*hamburgers**2 + 4*corn_cobs**2 >= 27, "c13")
m.addConstr(5*chicken_thighs + 5*bagged_salads + 2*corn_cobs >= 27, "c14")
m.addConstr(1*hamburgers**2 + 4*granola_bars**2 + 4*corn_cobs**2 >= 27, "c15")
m.addConstr(5*chicken_thighs + 5*bagged_salads + 1*hamburgers + 2*granola_bars + 2*corn_cobs >= 27, "c16")
m.addConstr(-6*bagged_salads**2 + 5*hamburgers**2 >= 0, "c17")
m.addConstr(-5*hamburgers**2 + 8*corn_cobs**2 >= 0, "c18")
m.addConstr(25*bagged_salads**2 + 1*hamburgers**2 <= 204, "c19")
m.addConstr(1*hamburgers + 2*granola_bars <= 156, "c20")
m.addConstr(5*chicken_thighs + 2*corn_cobs <= 117, "c21")
m.addConstr(5*bagged_salads + 2*corn_cobs <= 81, "c22")
m.addConstr(5*chicken_thighs + 2*granola_bars <= 58, "c23")
m.addConstr(5*chicken_thighs + 1*hamburgers <= 54, "c24")
m.addConstr(5*chicken_thighs + 5*bagged_salads <= 86, "c25")
m.addConstr(5*chicken_thighs + 5*bagged_salads + 2*corn_cobs <= 119, "c26")
m.addConstr(1*hamburgers + 2*granola_bars + 2*corn_cobs <= 93, "c27")
m.addConstr(25*bagged_salads**2 + 1*hamburgers**2 + 4*corn_cobs**2 <= 103, "c28")
m.addConstr(25*chicken_thighs**2 + 25*bagged_salads**2 + 1*hamburgers**2 <= 194, "c29")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

