
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="bagged_salads", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="hamburgers", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x4 = m.addVar(name="granola_bars", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x5 = m.addVar(name="corn_cobs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(8.94*x1*x2 + 3.49*x1*x4 + 6.96*x2**2 + 1.22*x2*x5 + 5.04*x3*x4 + 9.86*x3 + 1.62*x5, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 5*x2 + x3 + 2*x4 + 2*x5 <= 214)
m.addConstr(x3**2 + x4**2 >= 31)
m.addConstr(5*x1 + 5*x2 >= 24)
m.addConstr(5*x1 + 2*x4 >= 24)
m.addConstr(5*x2 + 2*x5 >= 23)
m.addConstr(x3 + 2*x5 >= 17)
m.addConstr(5*x2 + 2*x4 >= 39)
m.addConstr(5*x1 + x3 + 2*x5 >= 21)
m.addConstr(x1**2 + x2**2 + x5**2 >= 21)
m.addConstr(x3 + 2*x4 + 2*x5 >= 21)
m.addConstr(5*x1 + x3 + 2*x5 >= 29)
m.addConstr(5*x1 + 5*x2 + 2*x5 >= 29)
m.addConstr(x3 + 2*x4 + 2*x5 >= 29)
m.addConstr(x1**2 + x3**2 + x5**2 >= 27)
m.addConstr(5*x1 + 5*x2 + 2*x5 >= 27)
m.addConstr(x3**2 + x4**2 + x5**2 >= 27)
m.addConstr(x1 + x2 + x3 + x4 + x5 >= 27)
m.addConstr(-6*x2**2 + 5*x3**2 >= 0)
m.addConstr(-5*x3**2 + 8*x5**2 >= 0)
m.addConstr(x2**2 + x3**2 <= 204)
m.addConstr(x3 + 2*x4 <= 156)
m.addConstr(5*x1 + 2*x5 <= 117)
m.addConstr(5*x2 + 2*x5 <= 81)
m.addConstr(5*x1 + 2*x4 <= 58)
m.addConstr(5*x1 + x3 <= 54)
m.addConstr(5*x1 + 5*x2 <= 86)
m.addConstr(5*x1 + 5*x2 + 2*x5 <= 119)
m.addConstr(x3 + 2*x4 + 2*x5 <= 93)
m.addConstr(x2**2 + x3**2 + x5**2 <= 103)
m.addConstr(x1**2 + x2**2 + x3**2 <= 194)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken Thighs: ", x1.varValue)
    print("Bagged Salads: ", x2.varValue)
    print("Hamburgers: ", x3.varValue)
    print("Granola Bars: ", x4.varValue)
    print("Corn Cobs: ", x5.varValue)
else:
    print("The model is infeasible")
