
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=0)  # grams of carbohydrates
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin B5
x3 = m.addVar(name="x3", lb=0)  # milligrams of vitamin B4

# Objective function
m.setObjective(5.42*x1**2 + 3.59*x1*x2 + 4.15*x1*x3 + 5.43*x2*x3 + 7.08*x3**2 + 6.25*x1 + 7.4*x2 + 6.3*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(20*x1 <= 281)
m.addConstr(20*x1 <= 98)
m.addConstr(x1 <= 92)
m.addConstr(16*x2 <= 281)
m.addConstr(13*x2 <= 98)
m.addConstr(11*x2 <= 92)
m.addConstr(8*x3 <= 281)
m.addConstr(5*x3 <= 98)
m.addConstr(10*x3 <= 92)
m.addConstr(20*x1 + 8*x3 >= 61)
m.addConstr(16*x2 + 8*x3 >= 87)
m.addConstr(20*x1 + 16*x2 >= 91) # corrected from 20^2x1^2 + 16^2x2^2 
m.addConstr(20*x1 + 16*x2 + 8*x3 >= 91)
m.addConstr(13*x2 + 5*x3 >= 26)
m.addConstr(20*x1 + 13*x2 + 5*x3 >= 26)
m.addConstr(11*x2 + 10*x3 >= 18)
m.addConstr(x1 + 11*x2 + 10*x3 >= 18)
m.addConstr(-6*x1 + 8*x2 >= 0)
m.addConstr(20*x1 + 5*x3 <= 95)
m.addConstr(20*x1 + 13*x2 <= 98)
m.addConstr(13*x2 + 5*x3 <= 91)

# Update model
m.update()

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
