
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")
tomatoes = m.addVar(vtype=GRB.INTEGER, name="tomatoes")
kale_salads = m.addVar(vtype=GRB.INTEGER, name="kale_salads")
chicken_drumsticks = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_drumsticks")
cornichons = m.addVar(vtype=GRB.CONTINUOUS, name="cornichons")


# Set objective function
m.setObjective(1.53 * green_beans * tomatoes + 9.64 * tomatoes * kale_salads + 5.41 * tomatoes * cornichons + 5.42 * kale_salads**2 + 1.5 * kale_salads * chicken_drumsticks + 2.18 * kale_salads * cornichons + 1.32 * chicken_drumsticks**2 + 9.02 * chicken_drumsticks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * chicken_drumsticks + 19 * cornichons >= 55)
m.addConstr(8 * green_beans + 7 * kale_salads >= 62)
m.addConstr(11**2 * tomatoes**2 + 7**2 * kale_salads**2 >= 28)
m.addConstr(11**2 * tomatoes**2 + 19**2 * cornichons**2 >= 34)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks >= 43)
m.addConstr(8**2 * green_beans**2 + 11**2 * tomatoes**2 >= 26)
m.addConstr(8 * green_beans + 7 * kale_salads + 6 * chicken_drumsticks >= 65)
m.addConstr(8 * green_beans + 11 * tomatoes + 6 * chicken_drumsticks >= 65)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks + 19 * cornichons >= 65)
m.addConstr(8 * green_beans + 7 * kale_salads + 19 * cornichons >= 65)
m.addConstr(8 * green_beans + 6 * chicken_drumsticks + 19 * cornichons >= 65)
m.addConstr(8 * green_beans + 11 * tomatoes + 7 * kale_salads >= 65)
m.addConstr(8 * green_beans + 7 * kale_salads + 6 * chicken_drumsticks >= 46)
m.addConstr(8 * green_beans + 11 * tomatoes + 6 * chicken_drumsticks >= 46)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks + 19 * cornichons >= 46)
m.addConstr(8 * green_beans + 7 * kale_salads + 19 * cornichons >= 46)
m.addConstr(8**2 * green_beans**2 + 6**2 * chicken_drumsticks**2 + 19**2 * cornichons**2 >= 46)
m.addConstr(8 * green_beans + 11 * tomatoes + 7 * kale_salads >= 46)
m.addConstr(8**2 * green_beans**2 + 7**2 * kale_salads**2 + 6**2 * chicken_drumsticks**2 >= 52)
m.addConstr(8**2 * green_beans**2 + 11**2 * tomatoes**2 + 6**2 * chicken_drumsticks**2 >= 52)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks + 19 * cornichons >= 52)
m.addConstr(8**2 * green_beans**2 + 7**2 * kale_salads**2 + 19**2 * cornichons**2 >= 52)
m.addConstr(8 * green_beans + 6 * chicken_drumsticks + 19 * cornichons >= 52)
m.addConstr(8**2 * green_beans**2 + 11**2 * tomatoes**2 + 7**2 * kale_salads**2 >= 52)
m.addConstr(8 * green_beans + 7 * kale_salads + 6 * chicken_drumsticks >= 42)
m.addConstr(8 * green_beans + 11 * tomatoes + 6 * chicken_drumsticks >= 42)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks + 19 * cornichons >= 42)
m.addConstr(8**2 * green_beans**2 + 7**2 * kale_salads**2 + 19**2 * cornichons**2 >= 42)
m.addConstr(8 * green_beans + 6 * chicken_drumsticks + 19 * cornichons >= 42)
m.addConstr(8 * green_beans + 11 * tomatoes + 7 * kale_salads >= 42)
m.addConstr(8 * green_beans + 7 * kale_salads + 6 * chicken_drumsticks >= 43)
m.addConstr(8 * green_beans + 11 * tomatoes + 6 * chicken_drumsticks >= 43)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks + 19 * cornichons >= 43)
m.addConstr(8**2 * green_beans**2 + 7**2 * kale_salads**2 + 19**2 * cornichons**2 >= 43)
m.addConstr(8**2 * green_beans**2 + 6**2 * chicken_drumsticks**2 + 19**2 * cornichons**2 >= 43)
m.addConstr(8 * green_beans + 11 * tomatoes + 7 * kale_salads >= 43)
m.addConstr(8 * green_beans + 7 * kale_salads + 6 * chicken_drumsticks >= 59)
m.addConstr(8 * green_beans + 11 * tomatoes + 6 * chicken_drumsticks >= 59)
m.addConstr(11**2 * tomatoes**2 + 6**2 * chicken_drumsticks**2 + 19**2 * cornichons**2 >= 59)
m.addConstr(8 * green_beans + 7 * kale_salads + 19 * cornichons >= 59)
m.addConstr(8 * green_beans + 6 * chicken_drumsticks + 19 * cornichons >= 59)
m.addConstr(8**2 * green_beans**2 + 11**2 * tomatoes**2 + 7**2 * kale_salads**2 >= 59)
m.addConstr(17**2 * kale_salads**2 + 19**2 * chicken_drumsticks**2 >= 48)
m.addConstr(13**2 * green_beans**2 + 19**2 * chicken_drumsticks**2 >= 47)
m.addConstr(20 * tomatoes + 17 * kale_salads >= 27)
m.addConstr(13 * green_beans + 17 * kale_salads >= 43)
m.addConstr(20**2 * tomatoes**2 + 15**2 * cornichons**2 >= 33)
m.addConstr(13**2 * green_beans**2 + 15**2 * cornichons**2 >= 40)
m.addConstr(20**2 * tomatoes**2 + 17**2 * kale_salads**2 + 19**2 * chicken_drumsticks**2 >= 65)
m.addConstr(13 * green_beans + 19 * chicken_drumsticks + 15 * cornichons >= 65)
m.addConstr(20 * tomatoes + 17 * kale_salads + 19 * chicken_drumsticks >= 58)
m.addConstr(13 * green_beans + 19 * chicken_drumsticks + 15 * cornichons >= 58)
m.addConstr(-kale_salads**2 + 7 * chicken_drumsticks**2 >= 0)
m.addConstr(7 * kale_salads + 19 * cornichons <= 238)
m.addConstr(8 * green_beans + 6 * chicken_drumsticks <= 167)
m.addConstr(11 * tomatoes + 7 * kale_salads <= 279)
m.addConstr(8**2 * green_beans**2 + 7**2 * kale_salads**2 <= 260)
m.addConstr(11 * tomatoes + 6 * chicken_drumsticks <= 269)
m.addConstr(7**2 * kale_salads**2 + 6**2 * chicken_drumsticks**2 + 19**2 * cornichons**2 <= 233)
m.addConstr(11 * tomatoes + 7 * kale_salads + 19 * cornichons <= 176)
m.addConstr(8 * green_beans + 11 * tomatoes + 7 * kale_salads + 6 * chicken_drumsticks + 19 * cornichons <= 176)
m.addConstr(20 * tomatoes + 19 * chicken_drumsticks <= 117)
m.addConstr(20 * tomatoes + 17 * kale_salads <= 244)
m.addConstr(20 * tomatoes + 15 * cornichons <= 213)
m.addConstr(20 * tomatoes + 17 * kale_salads + 19 * chicken_drumsticks <= 261)
m.addConstr(17 * kale_salads + 19 * chicken_drumsticks + 15 * cornichons <= 343)
m.addConstr(20 * tomatoes + 19 * chicken_drumsticks + 15 * cornichons <= 81)
m.addConstr(13**2 * green_beans**2 + 19**2 * chicken_drumsticks**2 + 15**2 * cornichons**2 <= 181)
m.addConstr(13**2 * green_beans**2 + 20**2 * tomatoes**2 + 15**2 * cornichons**2 <= 307)
m.addConstr(13 * green_beans + 20 * tomatoes + 17 * kale_salads + 19 * chicken_drumsticks + 15 * cornichons <= 307)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

