
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hot_dogs")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")


# Set objective function
m.setObjective(8 * chicken_thighs + 7 * kale_salads + 2 * hot_dogs + 3 * bagged_salads, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * chicken_thighs + 6 * hot_dogs >= 21)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads >= 13)
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads >= 13)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs >= 13)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads >= 21)
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads >= 21)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs >= 21)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads >= 21)
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads >= 21)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs >= 21)
m.addConstr(3 * hot_dogs + 2 * bagged_salads >= 21)
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 2 * bagged_salads >= 20)
m.addConstr(8 * chicken_thighs + 3 * hot_dogs + 2 * bagged_salads >= 20)
m.addConstr(2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads >= 20)
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 2 * bagged_salads >= 13)
m.addConstr(8 * chicken_thighs + 3 * hot_dogs + 2 * bagged_salads >= 13)
m.addConstr(2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads >= 13)
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 2 * bagged_salads >= 20)
m.addConstr(8 * chicken_thighs + 3 * hot_dogs + 2 * bagged_salads >= 20)
m.addConstr(2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads >= 20)
m.addConstr(3 * kale_salads + 6 * bagged_salads >= 4)
m.addConstr(1 * kale_salads + 8 * bagged_salads <= 79)
m.addConstr(3 * chicken_thighs + 1 * kale_salads <= 36)
m.addConstr(3 * chicken_thighs + 8 * bagged_salads <= 22)
m.addConstr(6 * hot_dogs + 8 * bagged_salads <= 54)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 8 * bagged_salads <= 74)
m.addConstr(3 * chicken_thighs + 6 * hot_dogs + 8 * bagged_salads <= 76)
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs + 8 * bagged_salads <= 76)
m.addConstr(3 * hot_dogs + 2 * bagged_salads <= 24)
m.addConstr(2 * kale_salads + 3 * hot_dogs <= 84)
m.addConstr(8 * chicken_thighs + 3 * hot_dogs <= 89)
m.addConstr(8 * chicken_thighs + 2 * kale_salads <= 52)
m.addConstr(8 * chicken_thighs + 2 * bagged_salads <= 89)
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads <= 89)
m.addConstr(3 * hot_dogs + 6 * bagged_salads <= 40)
m.addConstr(3 * kale_salads + 3 * hot_dogs <= 17)
m.addConstr(5 * chicken_thighs + 3 * kale_salads <= 26)
m.addConstr(5 * chicken_thighs + 3 * hot_dogs + 6 * bagged_salads <= 25)
m.addConstr(5 * chicken_thighs + 3 * kale_salads + 3 * hot_dogs + 6 * bagged_salads <= 25)
m.addConstr(5 * chicken_thighs + 5 * hot_dogs <= 45)
m.addConstr(5 * hot_dogs + 2 * bagged_salads <= 25)
m.addConstr(8 * kale_salads + 2 * bagged_salads <= 56)
m.addConstr(5 * chicken_thighs + 8 * kale_salads + 5 * hot_dogs + 2 * bagged_salads <= 56)


# Resource Constraints
m.addConstr(3 * chicken_thighs + 1 * kale_salads + 6 * hot_dogs + 8 * bagged_salads <= 84)
m.addConstr(8 * chicken_thighs + 2 * kale_salads + 3 * hot_dogs + 2 * bagged_salads <= 94)
m.addConstr(5 * chicken_thighs + 3 * kale_salads + 3 * hot_dogs + 6 * bagged_salads <= 49)
m.addConstr(5 * chicken_thighs + 8 * kale_salads + 5 * hot_dogs + 2 * bagged_salads <= 85)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

