
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B12
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B3


    # Set objective function
    m.setObjective(5.84 * x0 + 1.76 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 7 * x1 >= 13, "c0")
    m.addConstr(4 * x0 + 4 * x1 >= 3, "c1")
    m.addConstr(5 * x0 + 9 * x1 >= 13, "c2")
    m.addConstr(5 * x0 - 9 * x1 >= 0, "c3")
    m.addConstr(3 * x0 + 7 * x1 <= 55, "c4")
    m.addConstr(4 * x0 + 4 * x1 <= 14, "c5")
    m.addConstr(5 * x0 + 9 * x1 <= 15, "c6")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

