
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B12")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")

# Set objective function
m.setObjective(5.84*x1 + 1.76*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 7*x2 >= 13, name="digestive_support_index_min")
m.addConstr(4*x1 + 4*x2 >= 3, name="cardiovascular_support_index_min")
m.addConstr(5*x1 + 9*x2 >= 13, name="cognitive_performance_index_min")
m.addConstr(5*x1 - 9*x2 >= 0, name="additional_constraint")
m.addConstr(3*x1 + 7*x2 <= 55, name="digestive_support_index_max")
m.addConstr(4*x1 + 4*x2 <= 14, name="cardiovascular_support_index_max")
m.addConstr(5*x1 + 9*x2 <= 15, name="cognitive_performance_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B12: {x1.x}")
    print(f"Milligrams of Vitamin B3: {x2.x}")
else:
    print("No optimal solution found")
