
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B12
x1 = model.addVar(name="x1")  # milligrams of vitamin B3

# Objective function: maximize 5.84*x0 + 1.76*x1
model.setObjective(5.84*x0 + 1.76*x1, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(3*x0 + 7*x1 >= 13, name="digestive_support_index_min")
model.addConstr(4*x0 + 4*x1 >= 3, name="cardiovascular_support_index_min")
model.addConstr(5*x0 + 9*x1 >= 13, name="cognitive_performance_index_min")
model.addConstr(5*x0 - 9*x1 >= 0, name="additional_constraint")
model.addConstr(3*x0 + 7*x1 <= 55, name="digestive_support_index_max")
model.addConstr(4*x0 + 4*x1 <= 14, name="cardiovascular_support_index_max")
model.addConstr(5*x0 + 9*x1 <= 15, name="cognitive_performance_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B12: {x0.varValue}")
    print(f"Milligrams of vitamin B3: {x1.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
