
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Bill
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by George
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # hours worked by Jean


    # Set objective function
    model.setObjective(3.77*x0 + 5.17*x1 + 8.77*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x0 + 10*x1 + 6*x2 >= 11, "c0")
    model.addConstr(13*x1 + 5*x2 >= 10, "c1")
    model.addConstr(8*x0 + 5*x2 >= 18, "c2")
    model.addConstr(8*x0 + 13*x1 >= 14, "c3")
    model.addConstr(3*x0 + 10*x1 <= 14, "c4")
    model.addConstr(3*x0 + 6*x2 <= 30, "c5")
    model.addConstr(3*x0 + 10*x1 + 6*x2 <= 30, "c6")
    model.addConstr(13*x1 + 5*x2 <= 54, "c7")
    model.addConstr(8*x0 + 13*x1 <= 20, "c8")
    model.addConstr(8*x0 + 5*x2 <= 29, "c9")
    model.addConstr(8*x0 + 13*x1 + 5*x2 <= 38, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
