
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='hours_worked_by_Bill', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='hours_worked_by_George', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_Jean', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(3.77 * x0 + 5.17 * x1 + 8.77 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x0 + 10 * x1 + 6 * x2 >= 11)
    model.addConstr(13 * x1 + 5 * x2 >= 10)
    model.addConstr(8 * x0 + 5 * x2 >= 18)
    model.addConstr(8 * x0 + 13 * x1 >= 14)
    model.addConstr(3 * x0 + 10 * x1 <= 14)
    model.addConstr(3 * x0 + 6 * x2 <= 30)
    model.addConstr(3 * x0 + 10 * x1 + 6 * x2 <= 30)
    model.addConstr(13 * x1 + 5 * x2 <= 54)
    model.addConstr(8 * x0 + 13 * x1 <= 20)
    model.addConstr(8 * x0 + 5 * x2 <= 29)
    model.addConstr(8 * x0 + 13 * x1 + 5 * x2 <= 38)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Bill: {x0.varValue}')
        print(f'Hours worked by George: {x1.varValue}')
        print(f'Hours worked by Jean: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
