
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='rotisserie_chickens', lb=0)
    x1 = model.addVar(name='ham_sandwiches', lb=0)
    x2 = model.addVar(name='potatoes', lb=0)

    # Define the objective function
    model.setObjective(2.4 * x0 + 2.19 * x1 + 6.37 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(15 * x0 + 6 * x1 + 15 * x2 >= 28)
    model.addConstr(17 * x1 + 21 * x2 >= 25)
    model.addConstr(20 * x0 + 21 * x2 >= 38)
    model.addConstr(20 * x0 + 17 * x1 + 21 * x2 >= 35)
    model.addConstr(5 * x0 + 14 * x1 >= 13)
    model.addConstr(14 * x1 + 8 * x2 >= 14)
    model.addConstr(5 * x0 + 8 * x2 >= 14)
    model.addConstr(15 * x0 + 6 * x1 <= 40)
    model.addConstr(15 * x0 + 6 * x1 + 15 * x2 <= 122)
    model.addConstr(17 * x1 + 21 * x2 <= 77)
    model.addConstr(20 * x0 + 17 * x1 <= 105)
    model.addConstr(20 * x0 + 21 * x2 <= 114)
    model.addConstr(20 * x0 + 17 * x1 + 21 * x2 <= 143)
    model.addConstr(5 * x0 + 14 * x1 <= 63)
    model.addConstr(14 * x1 + 8 * x2 <= 60)
    model.addConstr(5 * x0 + 14 * x1 + 8 * x2 <= 60)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('rotisserie chickens: ', x0.varValue)
        print('ham sandwiches: ', x1.varValue)
        print('potatoes: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
