
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")
    bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
    bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
    ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ham_sandwiches")


    # Set objective function
    m.setObjective(5.64 * apple_pies + 5.52 * bowls_of_pasta + 2.47 * bowls_of_cereal + 8.43 * ham_sandwiches, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(28 * apple_pies + 24 * bowls_of_cereal >= 116, "tastiness_constraint1")
    m.addConstr(24 * bowls_of_cereal + 14 * ham_sandwiches <= 387, "tastiness_constraint2")
    m.addConstr(28 * apple_pies + 24 * bowls_of_cereal <= 192, "tastiness_constraint3")
    m.addConstr(28 * apple_pies + 24 * bowls_of_pasta <= 179, "tastiness_constraint4")
    m.addConstr(24 * bowls_of_pasta + 24 * bowls_of_cereal <= 480, "tastiness_constraint5")
    m.addConstr(28 * apple_pies + 24 * bowls_of_pasta + 24 * bowls_of_cereal + 14 * ham_sandwiches <= 480, "tastiness_constraint6")
    m.addConstr(23 * bowls_of_pasta + 4 * bowls_of_cereal <= 68, "cost_constraint1")
    m.addConstr(27 * apple_pies + 23 * bowls_of_pasta <= 132, "cost_constraint2")
    m.addConstr(27 * apple_pies + 2 * ham_sandwiches <= 133, "cost_constraint3")
    m.addConstr(23 * bowls_of_pasta + 2 * ham_sandwiches <= 80, "cost_constraint4")
    m.addConstr(23 * bowls_of_pasta + 4 * bowls_of_cereal + 2 * ham_sandwiches <= 139, "cost_constraint5")
    m.addConstr(27 * apple_pies + 23 * bowls_of_pasta + 4 * bowls_of_cereal + 2 * ham_sandwiches <= 139, "cost_constraint6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
