
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='apple_pies', lb=0)  # No lower bound specified, assuming 0
    x1 = model.addVar(name='bowls_of_pasta', lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name='bowls_of_cereal', lb=0)  # No lower bound specified, assuming 0
    x3 = model.addVar(name='ham_sandwiches', lb=0, integrality=gurobi.GRB.INTEGER)  # Restricted to integer

    # Objective function
    model.setObjective(5.64*x0 + 5.52*x1 + 2.47*x2 + 8.43*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(28*x0 + 24*x2 >= 116)
    model.addConstr(24*x2 + 14*x3 <= 387)
    model.addConstr(28*x0 + 24*x2 <= 192)
    model.addConstr(28*x0 + 24*x1 <= 179)
    model.addConstr(24*x1 + 24*x2 <= 480)
    model.addConstr(28*x0 + 24*x1 + 24*x2 + 14*x3 <= 480)
    model.addConstr(23*x1 + 4*x2 <= 68)
    model.addConstr(27*x0 + 23*x1 <= 132)
    model.addConstr(27*x0 + 2*x3 <= 133)
    model.addConstr(23*x1 + 2*x3 <= 80)
    model.addConstr(23*x1 + 4*x2 + 2*x3 <= 139)
    model.addConstr(27*x0 + 23*x1 + 4*x2 + 2*x3 <= 139)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Apple pies: ', x0.varValue)
        print('Bowls of pasta: ', x1.varValue)
        print('Bowls of cereal: ', x2.varValue)
        print('Ham sandwiches: ', x3.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
