
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_B4")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_D")


    # Set objective function
    m.setObjective(2*x0**2 + 5*x0, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(x0**2 + x1**2 >= 16, "immune_support_squared")
    m.addConstr(x0 + x1 >= 16, "immune_support_min")
    m.addConstr(10*x0 - 10*x1 >= 0, "b4_d_ratio")
    m.addConstr(x0 + x1 <= 19, "immune_support_max")
    m.addConstr(1*x0 + 8*x1 <= 36, "resource_constraint")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_B4: %g' % x0.x)
        print('vitamin_D: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
