
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Add variables
x1 = m.addVar(name="milligrams_of_vitamin_B4", lb=-GRB.INFINITY, ub=GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_D", lb=-GRB.INFINITY, ub=GRB.INFINITY)

# Set the objective function
m.setObjective(2*x1**2 + 5*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1**2 + x2**2 >= 16, name="total_combinedimmune_support_index_squared")
m.addConstr(x1 + 8*x2 >= 16, name="total_combined_immune_support_index_min")
m.addConstr(10*x1 - 10*x2 >= 0, name="vitamin_b4_over_vitamin_d")
m.addConstr(x1 + 8*x2 <= 19, name="total_combined_immune_support_index_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B4: {x1.x}")
    print(f"Milligrams of Vitamin D: {x2.x}")
else:
    print("No optimal solution found")
