
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B4
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin D

    # Objective function
    model.setObjective(2*x1**2 + 5*x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1**2 + x2**2 >= 16)
    model.addConstr(x1 + x2 >= 16)
    model.addConstr(10*x1 - 10*x2 >= 0)
    model.addConstr(x1 + x2 <= 19)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B4: {x1.varValue}")
        print(f"Milligrams of vitamin D: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
