
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank = model.addVar(vtype=GRB.INTEGER, name="hank")
    bill = model.addVar(vtype=GRB.INTEGER, name="bill")
    jean = model.addVar(name="jean")
    dale = model.addVar(name="dale")

    # Set objective function
    obj = 1.77*hank**2 + 8.58*hank*bill + 2.9*hank*jean + 9.51*hank*dale + 5.01*bill**2 + 3.71*bill*jean + 3.57*bill*dale + 3.62*jean*dale + 4.16*dale**2 + 7.54*hank + 6.0*bill + 7.17*jean + 8.16*dale
    model.setObjective(obj, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*bill + 3*dale >= 28, "c0")
    model.addConstr(5*bill + 1*jean >= 24, "c1")
    model.addConstr(1*jean**2 + 3*dale**2 >= 13, "c2")
    model.addConstr(2*hank**2 + 5*bill**2 >= 23, "c3")
    model.addConstr(2*hank**2 + 1*jean**2 + 3*dale**2 >= 19, "c4")
    model.addConstr(2*hank**2 + 5*bill**2 + 3*dale**2 >= 19, "c5")
    model.addConstr(2*hank**2 + 1*jean**2 + 3*dale**2 >= 28, "c6")
    model.addConstr(2*hank + 5*bill + 3*dale >= 28, "c7")
    model.addConstr(2*hank + 5*bill + 1*jean + 3*dale >= 28, "c8")
    model.addConstr(8*bill + 1*jean >= 26, "c9")
    model.addConstr(6*hank + 8*bill + 1*jean + 2*dale >= 26, "c10")
    model.addConstr(-7*bill**2 + 1*dale**2 >= 0, "c11")
    model.addConstr(5*bill + 1*jean <= 118, "c12")
    model.addConstr(5*bill + 3*dale <= 69, "c13")
    model.addConstr(8*bill**2 + 2*dale**2 <= 62, "c14")
    model.addConstr(6*hank**2 + 2*dale**2 <= 98, "c15")
    model.addConstr(6*hank + 8*bill + 2*dale <= 91, "c16")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('hank:', hank.x)
        print('bill:', bill.x)
        print('jean:', jean.x)
        print('dale:', dale.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
