
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
x1 = m.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
x2 = m.addVar(name='x2')  # hours worked by Jean
x3 = m.addVar(name='x3')  # hours worked by Dale

# Objective function
m.setObjective(1.77*x0**2 + 8.58*x0*x1 + 2.9*x0*x2 + 9.51*x0*x3 + 5.01*x1**2 + 3.71*x1*x2 + 3.57*x1*x3 + 3.62*x2*x3 + 4.16*x3**2 + 7.54*x0 + 6.0*x1 + 7.17*x2 + 8.16*x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 3*x3 >= 28)
m.addConstr(5*x1 + 1*x2 >= 24)
m.addConstr(1*x2**2 + 3*x3**2 >= 13)
m.addConstr(2*x0**2 + 5*x1**2 >= 23)
m.addConstr(2*x0**2 + 1*x2**2 + 3*x3**2 >= 19)
m.addConstr(2*x0**2 + 5*x1**2 + 3*x3**2 >= 19)
m.addConstr(2*x0**2 + 1*x2**2 + 3*x3**2 >= 28)
m.addConstr(x0 + x1 + x3 >= 28)
m.addConstr(x0 + x1 + x2 + x3 >= 28)
m.addConstr(8*x1 + 1*x2 >= 26)
m.addConstr(6*x0 + 8*x1 + 1*x2 + 2*x3 >= 26)
m.addConstr(-7*x1**2 + 1*x3**2 >= 0)
m.addConstr(5*x1 + 1*x2 <= 118)
m.addConstr(5*x1 + 3*x3 <= 69)
m.addConstr(8*x1**2 + 2*x3**2 <= 62)
m.addConstr(6*x0**2 + 2*x3**2 <= 98)
m.addConstr(6*x0 + 8*x1 + 2*x3 <= 91)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
