
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="eggs", vtype=gurobi.GRB.CONTINUOUS)
x2 = m.addVar(name="apple_pies", vtype=gurobi.GRB.CONTINUOUS)

# Objective function
m.setObjective(3.99*x0 + 4.83*x1 + 2.67*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(29*x0 + 15*x1 + x2 <= 160)
m.addConstr(28*x0 + 28*x1 + 8*x2 <= 210)
m.addConstr(24*x0 + 5*x1 + 25*x2 <= 365)
m.addConstr(8*x0 + 23*x1 + 20*x2 <= 348)
m.addConstr(29*x0 + x2 >= 52)
m.addConstr(29*x0 + 15*x1 >= 35)
m.addConstr(15*x1 + x2 >= 29)
m.addConstr(29*x0 + 15*x1 + x2 >= 44)
m.addConstr(28*x0 + 8*x2 >= 33)
m.addConstr(28*x0 + 28*x1 >= 60)
m.addConstr(28*x0 + 28*x1 + 8*x2 >= 60)
m.addConstr(24*x0 + 25*x2 >= 119)
m.addConstr(24*x0 + 5*x1 >= 83)
m.addConstr(24*x0 + 5*x1 + 25*x2 >= 117)
m.addConstr(8*x0 + 23*x1 >= 76)
m.addConstr(23*x1 + 20*x2 >= 71)
m.addConstr(8*x0 + 23*x1 + 20*x2 >= 71)
m.addConstr(6*x0 - 4*x1 >= 0)
m.addConstr(6*x1 - 9*x2 >= 0)
m.addConstr(29*x0 + 15*x1 <= 160)
m.addConstr(29*x0 + x2 <= 68)
m.addConstr(28*x0 + 8*x2 <= 190)
m.addConstr(28*x0 + 28*x1 <= 85)
m.addConstr(28*x1 + 8*x2 <= 109)
m.addConstr(8*x0 + 23*x1 <= 150)
m.addConstr(8*x0 + 23*x1 + 20*x2 <= 310)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Bananas: ", x0.varValue)
    print("Eggs: ", x1.varValue)
    print("Apple Pies: ", x2.varValue)
else:
    print("The model is infeasible")
