
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bagged_salads = m.addVar(lb=0, name="bagged_salads")
tomatoes = m.addVar(lb=0, name="tomatoes")
cornichons = m.addVar(lb=0, name="cornichons")


# Set objective function
m.setObjective(6*bagged_salads + 6*tomatoes + 3*cornichons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*bagged_salads + 3*cornichons >= 59)
m.addConstr(20*tomatoes + 3*cornichons >= 56)
m.addConstr(8*bagged_salads + 20*tomatoes + 3*cornichons >= 56)
m.addConstr(4*bagged_salads + 4*tomatoes >= 58)
m.addConstr(4*bagged_salads + 4*cornichons >= 87)
m.addConstr(4*tomatoes + 4*cornichons >= 33)
m.addConstr(4*bagged_salads + 4*tomatoes + 4*cornichons >= 33)
m.addConstr(-6*tomatoes + 4*cornichons >= 0)
m.addConstr(-6*bagged_salads + 5*cornichons >= 0)
m.addConstr(8*bagged_salads + 20*tomatoes + 3*cornichons <= 184)
m.addConstr(4*bagged_salads + 4*tomatoes <= 155)
m.addConstr(4*tomatoes + 4*cornichons <= 107)
m.addConstr(4*bagged_salads + 4*tomatoes + 4*cornichons <= 178)

# Resource Constraints
m.addConstr(8*bagged_salads + 20*tomatoes + 3*cornichons <= 288)
m.addConstr(4*bagged_salads + 4*tomatoes + 4*cornichons <= 298)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

