
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="bagged_salads", lb=0)
x1 = m.addVar(name="tomatoes", lb=0)
x2 = m.addVar(name="cornichons", lb=0)

# Objective function
m.setObjective(6*x0 + 6*x1 + 3*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(8*x0 + 3*x2 >= 59)
m.addConstr(20*x1 + 3*x2 >= 56)
m.addConstr(8*x0 + 20*x1 + 3*x2 >= 56)
m.addConstr(4*x0 + 4*x1 >= 58)
m.addConstr(4*x0 + 4*x2 >= 87)
m.addConstr(4*x1 + 4*x2 >= 33)
m.addConstr(4*x0 + 4*x1 + 4*x2 >= 33)
m.addConstr(-6*x1 + 4*x2 >= 0)
m.addConstr(-6*x0 + 5*x2 >= 0)
m.addConstr(8*x0 + 20*x1 + 3*x2 <= 184)
m.addConstr(4*x0 + 4*x1 <= 155)
m.addConstr(4*x1 + 4*x2 <= 107)
m.addConstr(4*x0 + 4*x1 + 4*x2 <= 178)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bagged_salads: ", x0.varValue)
    print("tomatoes: ", x1.varValue)
    print("cornichons: ", x2.varValue)
else:
    print("The model is infeasible")
