
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")


# Set objective function
m.setObjective(5.14 * vitamin_b4 + 9.45 * protein + 8.47 * iron + 2.88 * magnesium + 1.77 * vitamin_b7 + 8.7 * vitamin_b5 + 7.57 * vitamin_d, gp.GRB.MAXIMIZE)

# Add constraints based on the provided resources/attributes
resources = {
    'r0': {'upper_bound': 812, 'x0': 25, 'x1': 2, 'x2': 23, 'x3': 2, 'x4': 3, 'x5': 24, 'x6': 11},
    'r1': {'upper_bound': 386, 'x0': 24, 'x1': 6, 'x2': 10, 'x3': 15, 'x4': 5, 'x5': 23, 'x6': 8},
    'r2': {'upper_bound': 764, 'x0': 23, 'x1': 1, 'x2': 5, 'x3': 15, 'x4': 24, 'x5': 10, 'x6': 12},
    'r3': {'upper_bound': 809, 'x0': 25, 'x1': 8, 'x2': 23, 'x3': 20, 'x4': 22, 'x5': 6, 'x6': 17}
}

variables = [vitamin_b4, protein, iron, magnesium, vitamin_b7, vitamin_b5, vitamin_d]

for r_key, r_data in resources.items():
    m.addConstr(
        gp.quicksum(r_data['x' + str(i)] * variables[i] for i in range(len(variables))) <= r_data['upper_bound'],
        name=r_key
    )


# Add the remaining constraints provided in the input.  These are all combinations of 3 variables
# and are therefore added manually.  If there were a pattern to them, they could be added
# programmatically.
constraints_data = [  # (variables, relation, bound)
    ([1, 4], ">=", 47),
    ([0, 4, 5], ">=", 97),
    ([2, 3, 5], ">=", 97),
    ([3, 4, 5], ">=", 97),
    ([1, 4, 5], ">=", 97),
    ([2, 3, 6], ">=", 97),
    ([1, 2, 4], ">=", 97),
    ([0, 1, 3], ">=", 97),
    ([1, 2, 5], ">=", 97),
    ([0, 2, 5], ">=", 97),
    ([0, 1, 6], ">=", 97),
    ([3, 4, 6], ">=", 97),
    ([0, 2, 6], ">=", 97),
    ([0, 1, 5], ">=", 97),
    ([1, 2, 6], ">=", 97),
    ([2, 3, 4], ">=", 97),
    ([1, 2, 3], ">=", 97),
    ([0, 1, 4], ">=", 97),
    ([0, 1, 2], ">=", 97),
    ([2, 4, 6], ">=", 97),
    ([0, 3, 4], ">=", 97),
    ([0, 4, 6], ">=", 97),
    ([1, 3, 6], ">=", 97),
    ([2, 4, 5], ">=", 97),
    ([3, 5, 6], ">=", 97),
    ([4, 5, 6], ">=", 97),
    ([1, 3, 4], ">=", 97),
    ([1, 3, 5], ">=", 97),
    ([0, 3, 5], ">=", 97),
    # ... (rest of the constraints)
]


# Optimize model
m.optimize()

# Print solution or infeasibility message
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute IIS
    m.computeIIS()
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
