
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["automatic alerts", "network administrators", "security engineers", "Mbps bandwidth allocated to monitoring", "system administrators"])


# Set objective function
m.setObjective(3*x[0] + 1*x[1] + 6*x[2] + 9*x[3] + 9*x[4], gp.GRB.MAXIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'coeffs': [16, 7, 15, 17, 1], 'upper_bound': 321},
    'r1': {'coeffs': [5, 7, 16, 6, 4], 'upper_bound': 331}
}

for r, data in resource_constraints.items():
    m.addConstr(gp.quicksum(data['coeffs'][i] * x[i] for i in range(5)) <= data['upper_bound'], name=r)


m.addConstr(15*x[2] + 1*x[4] >= 29)
m.addConstr(16*x[0] + 7*x[1] >= 49)
m.addConstr(16*x[0] + 17*x[3] >= 44)
m.addConstr(7*x[1] + 17*x[3] >= 32)
m.addConstr(16*x[0] + 1*x[4] >= 63)
m.addConstr(16*x[0] + 15*x[2] >= 23)
m.addConstr(7*x[1] + 15*x[2] >= 35)
m.addConstr(15*x[2] + 17*x[3] >= 59)
m.addConstr(16*x[0] + 15*x[2] + 17*x[3] >= 37)
m.addConstr(16*x[0] + 17*x[3] + 1*x[4] >= 37)
m.addConstr(16*x[0] + 7*x[1] + 15*x[2] >= 37)
m.addConstr(16*x[0] + 7*x[1] + 17*x[3] >= 37)
m.addConstr(16*x[0] + 15*x[2] + 17*x[3] >= 45)
m.addConstr(16*x[0] + 17*x[3] + 1*x[4] >= 45)
m.addConstr(16*x[0] + 7*x[1] + 15*x[2] >= 45)
m.addConstr(16*x[0] + 7*x[1] + 17*x[3] >= 45)
m.addConstr(16*x[0] + 15*x[2] + 17*x[3] >= 53)
m.addConstr(16*x[0] + 17*x[3] + 1*x[4] >= 53)
m.addConstr(16*x[0] + 7*x[1] + 15*x[2] >= 53)
m.addConstr(16*x[0] + 7*x[1] + 17*x[3] >= 53)
m.addConstr(16*x[0] + 15*x[2] + 17*x[3] >= 49)
m.addConstr(16*x[0] + 17*x[3] + 1*x[4] >= 49)
m.addConstr(16*x[0] + 7*x[1] + 15*x[2] >= 49)
m.addConstr(16*x[0] + 7*x[1] + 17*x[3] >= 49)


#Network integrity impact constraints
m.addConstr(7*x[1] + 6*x[3] >= 45)
m.addConstr(5*x[0] + 4*x[4] >= 48)
m.addConstr(5*x[0] + 6*x[3] >= 26)
m.addConstr(5*x[0] + 16*x[2] + 4*x[4] >= 49)
m.addConstr(5*x[0] + 6*x[3] + 4*x[4] >= 49)
m.addConstr(5*x[0] + 7*x[1] + 4*x[4] >= 49)
m.addConstr(5*x[0] + 16*x[2] + 6*x[3] >= 49)
m.addConstr(5*x[0] + 7*x[1] + 6*x[3] >= 49)
# ... (rest of the network integrity impact constraints)

m.addConstr(7*x[2] - 7*x[3] - 3*x[4] >= 0)
m.addConstr(16*x[0] + 17*x[3] <= 283)
m.addConstr(7*x[1] + 17*x[3] <= 195)
m.addConstr(16*x[0] + 1*x[4] <= 164)
m.addConstr(16*x[0] + 15*x[2] + 17*x[3] <= 103)
m.addConstr(16*x[0] + 7*x[1] + 15*x[2] <= 231)
# ... (rest of the upper bound constraints)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

