
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
bill_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
jean_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="jean_hours")

# Set objective function
model.setObjective(7.94 * bill_hours + 3.2 * jean_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * bill_hours + 12 * jean_hours >= 15, "min_cost")
model.addConstr(-6 * bill_hours + 3 * jean_hours >= 0, "bill_jean_ratio")
model.addConstr(6 * bill_hours + 12 * jean_hours <= 42, "max_cost_1")  # Redundant due to equality constraint below
model.addConstr(6 * bill_hours + 12 * jean_hours == 42, "max_cost_2")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Hours worked by Bill: {bill_hours.x}")
    print(f"Hours worked by Jean: {jean_hours.x}")
    print(f"Optimal Objective Value: {model.objVal}")

