
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Set the objective function
m.setObjective(7.94*x1 + 3.2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 12*x2 >= 15, name="total_cost_lower_bound")
m.addConstr(-6*x1 + 3*x2 >= 0, name="linear_constraint")
m.addConstr(6*x1 + 12*x2 <= 42, name="total_cost_upper_bound")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Hours worked by Jean: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
