
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Bill', lb=0)  # Continuous variable
    x2 = model.addVar(name='hours_worked_by_Jean', lb=0, vtype=gurobi.GRB.INTEGER)  # Integer variable

    # Define the objective function
    model.setObjective(7.94 * x1 + 3.2 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(6 * x1 + 12 * x2 >= 15, name='total_cost_min')
    model.addConstr(-6 * x1 + 3 * x2 >= 0, name='cost_ratio')
    model.addConstr(6 * x1 + 12 * x2 <= 42, name='total_cost_max')

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Bill: {x1.varValue}')
        print(f'Hours worked by Jean: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
