
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    m.setObjective(2*x0 + 1*x1 + 6*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 10*x1 >= 29, "c0")
    m.addConstr(10*x0 + 22*x1 >= 52, "c1")
    m.addConstr(10*x0 + 4*x2 >= 40, "c2")
    m.addConstr(17*x1 + 2*x2 >= 31, "c3")
    m.addConstr(4*x1 + 17*x2 >= 42, "c4")
    m.addConstr(8*x0 + 17*x2 >= 16, "c5")
    m.addConstr(13*x0 + 10*x1 <= 99, "c6")
    m.addConstr(13*x0 + 1*x2 <= 104, "c7")
    m.addConstr(13*x0 + 10*x1 + 1*x2 <= 161, "c8")
    m.addConstr(10*x0 + 4*x2 <= 130, "c9")
    m.addConstr(22*x1 + 4*x2 <= 130, "c10")
    m.addConstr(10*x0 + 22*x1 + 4*x2 <= 130, "c11")
    m.addConstr(5*x0 + 2*x2 <= 72, "c12")
    m.addConstr(17*x1 + 2*x2 <= 73, "c13")
    m.addConstr(5*x0 + 17*x1 + 2*x2 <= 73, "c14")
    m.addConstr(20*x1 + 5*x2 <= 183, "c15")
    m.addConstr(7*x0 + 20*x1 + 5*x2 <= 151, "c16")
    m.addConstr(8*x0 + 17*x2 <= 127, "c17")
    m.addConstr(8*x0 + 4*x1 <= 51, "c18")
    m.addConstr(4*x1 + 17*x2 <= 106, "c19")



    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
