
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin E
x1 = model.addVar(name="x1", lb=0)  # milligrams of magnesium
x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin A

# Objective function
model.setObjective(2 * x0 + x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(13 * x0 + 10 * x1 >= 29)
model.addConstr(10 * x0 + 22 * x1 >= 52)
model.addConstr(10 * x0 + 4 * x2 >= 40)
model.addConstr(17 * x1 + 2 * x2 >= 31)
model.addConstr(4 * x1 + 17 * x2 >= 42)
model.addConstr(8 * x0 + 17 * x2 >= 16)
model.addConstr(13 * x0 + 10 * x1 <= 99)
model.addConstr(13 * x0 + x2 <= 104)
model.addConstr(13 * x0 + 10 * x1 + x2 <= 161)
model.addConstr(10 * x0 + 22 * x1 + 4 * x2 <= 130)
model.addConstr(10 * x0 + 4 * x2 <= 130)
model.addConstr(5 * x0 + 17 * x1 + 2 * x2 <= 73)
model.addConstr(7 * x0 + 20 * x1 + 5 * x2 <= 183)
model.addConstr(7 * x0 + 20 * x1 + 5 * x2 <= 151)
model.addConstr(8 * x0 + 4 * x1 + 17 * x2 <= 106)
model.addConstr(8 * x0 + 4 * x1 <= 51)
model.addConstr(4 * x1 + 17 * x2 <= 106)
model.addConstr(5 * x0 + 17 * x1 + 2 * x2 <= 73)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin E: {x0.varValue}")
    print(f"Milligrams of magnesium: {x1.varValue}")
    print(f"Milligrams of vitamin A: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
