
import gurobipy as gp

# Create a new model
m = gp.Model("Planting Optimization")

# Create variables
chrysanthemums = m.addVar(vtype=gp.GRB.INTEGER, name="chrysanthemums")
strawberry_bushes = m.addVar(vtype=gp.GRB.INTEGER, name="strawberry_bushes")
decorative_cabbages = m.addVar(vtype=gp.GRB.INTEGER, name="decorative_cabbages")
boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")

# Set objective function
m.setObjective(8*chrysanthemums**2 + 6*chrysanthemums*strawberry_bushes + 4*chrysanthemums*decorative_cabbages + 6*strawberry_bushes*decorative_cabbages + 6*strawberry_bushes*boxwoods + 5*decorative_cabbages*boxwoods + boxwoods**2 + 5*chrysanthemums + 7*strawberry_bushes + 6*decorative_cabbages + boxwoods, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods <= 275)
m.addConstr(18*chrysanthemums + 22*decorative_cabbages >= 68*144)
m.addConstr(18**2*chrysanthemums**2 + 21**2*boxwoods**2 >= 43*144**2)
m.addConstr(15*strawberry_bushes + 21*boxwoods >= 54*144)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes >= 46*144)
m.addConstr(22**2*decorative_cabbages**2 + 21**2*boxwoods**2 >= 63*144**2)
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods >= 57*144)
m.addConstr(15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods >= 57*144)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages >= 57*144)
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods >= 56*144)
m.addConstr(15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods >= 56*144)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages >= 56*144)
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods >= 35*144)
m.addConstr(15**2*strawberry_bushes**2 + 22**2*decorative_cabbages**2 + 21**2*boxwoods**2 >= 35*144**2)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages >= 35*144)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages + 21*boxwoods >= 35*144)
m.addConstr(-7*chrysanthemums**2 - 4*decorative_cabbages**2 + 4*boxwoods**2 >= 0)
m.addConstr(15**2*strawberry_bushes**2 + 22**2*decorative_cabbages**2 <= 266*144**2)
m.addConstr(22**2*decorative_cabbages**2 + 21**2*boxwoods**2 <= 105*144**2)
m.addConstr(18**2*chrysanthemums**2 + 15**2*strawberry_bushes**2 <= 218*144**2)
m.addConstr(18*chrysanthemums + 15*strawberry_bushes + 22*decorative_cabbages <= 85*144)
m.addConstr(15**2*strawberry_bushes**2 + 22**2*decorative_cabbages**2 + 21**2*boxwoods**2 <= 130*144**2)
m.addConstr(18*chrysanthemums + 22*decorative_cabbages + 21*boxwoods <= 87*144)
m.addConstr(18**2*chrysanthemums**2 + 15**2*strawberry_bushes**2 + 21**2*boxwoods**2 <= 96*144**2)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chrysanthemums:', chrysanthemums.x)
    print('strawberry_bushes:', strawberry_bushes.x)
    print('decorative_cabbages:', decorative_cabbages.x)
    print('boxwoods:', boxwoods.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

