
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="ringo_hours")
    laura_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="laura_hours")


    # Set objective function
    model.setObjective(9.58*ringo_hours**2 + 1.36*ringo_hours*laura_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*ringo_hours**2 + 12*laura_hours**2 >= 21, "computer_competence_min")
    model.addConstr(6*ringo_hours + 12*laura_hours >= 61, "organization_score_min")
    model.addConstr(8*ringo_hours - 4*laura_hours >= 0, "ringo_laura_relation")
    model.addConstr(2*ringo_hours**2 + 12*laura_hours**2 <= 46, "computer_competence_max")
    model.addConstr(2*ringo_hours + 12*laura_hours <= 46, "computer_competence_linear_max")
    model.addConstr(6*ringo_hours**2 + 12*laura_hours**2 <= 139, "organization_score_max")
    model.addConstr(6*ringo_hours + 12*laura_hours <= 139, "organization_score_linear_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Ringo's hours: {ringo_hours.x}")
        print(f"Laura's hours: {laura_hours.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
