
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x2 = model.addVar(name="x2")  # hours worked by Laura

    # Objective function
    model.setObjective(9.58 * x1**2 + 1.36 * x1 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2 * x1 <= 60)
    model.addConstr(6 * x1 <= 151)
    model.addConstr(12 * x2 <= 60)
    model.addConstr(12 * x2 <= 151)
    model.addConstr(2 * x1**2 + 12 * x2**2 >= 21)
    model.addConstr(6 * x1 + 12 * x2 >= 61)
    model.addConstr(8 * x1 - 4 * x2 >= 0)
    model.addConstr(2 * x1**2 + 12 * x2**2 <= 46)
    model.addConstr(2 * x1 + 12 * x2 <= 46)
    model.addConstr(6 * x1**2 + 12 * x2**2 <= 139)
    model.addConstr(6 * x1 + 12 * x2 <= 139)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
