
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin D
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype='I', name="x2")  # milligrams of vitamin B7
x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of magnesium
x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype='I', name="x4")  # milligrams of zinc
x5 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype='I', name="x5")  # milligrams of vitamin B2

# Objective function
model.setObjective(5.67 * x1 + 8.95 * x2 + 7.6 * x3 + 4.9 * x4 + 4.43 * x5, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x2 + x4 >= 9)
model.addConstr(x2 + x3 + x4 >= 6)
model.addConstr(x2 + x4 + x5 >= 6)
model.addConstr(x1 + x4 + x5 >= 6)
model.addConstr(x2 + x3 + x5 >= 6)
model.addConstr(x2 + x3 + x4 >= 8)
model.addConstr(x2 + x4 + x5 >= 8)
model.addConstr(x1 + x4 + x5 >= 8)
model.addConstr(x2 + x3 + x5 >= 8)
model.addConstr(x2 + x3 + x4 >= 6)
model.addConstr(x2 + x4 + x5 >= 6)
model.addConstr(x1 + x4 + x5 >= 6)
model.addConstr(x2 + x3 + x5 >= 6)
model.addConstr(x2 + x3 + x4 >= 12)
model.addConstr(x2 + x4 + x5 >= 12)
model.addConstr(x1 + x4 + x5 >= 12)
model.addConstr(x2 + x3 + x5 >= 12)
model.addConstr(x4 + x5 <= 58)
model.addConstr(x3 + x4 <= 54)
model.addConstr(x1 + x4 <= 31)
model.addConstr(x1 + x3 <= 41)
model.addConstr(x2 + x3 <= 48)
model.addConstr(x2 + x3 + x5 <= 35)
model.addConstr(x1 + x2 + x3 <= 44)
model.addConstr(x1 + x2 + x5 <= 50)
model.addConstr(x3 + x4 + x5 <= 45)
model.addConstr(x2 + x4 + x5 <= 33)
model.addConstr(x1 + x2 + x3 + x4 + x5 <= 33)

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No solution found")
