
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["cucumber_vines", "carrots", "vincas", "roses"])

    # Set objective function
    m.setObjective(6*x[0] + 8*x[1] + 2*x[2] + 1*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x[0] + x[2] + x[3] >= 24)
    m.addConstr(x[0] + x[1] + x[2] >= 24)
    m.addConstr(x[0] + x[2] + x[3] >= 18)
    m.addConstr(x[0] + x[1] + x[2] >= 18)
    m.addConstr(x[2] + x[3] >= 34)
    m.addConstr(8*x[0] + x[2] >= 35)
    m.addConstr(13*x[1] + 3*x[3] >= 30)
    m.addConstr(8*x[0] + 3*x[3] >= 22)
    m.addConstr(8*x[0] + 13*x[1] + x[2] >= 34)
    m.addConstr(x[0] + x[2] <= 81)
    m.addConstr(x[1] + x[2] <= 107)
    m.addConstr(x[1] + x[3] <= 99)
    m.addConstr(x[0] + x[3] <= 141)
    m.addConstr(x[2] + x[3] <= 68)
    m.addConstr(x[0] + x[1] <= 60)
    m.addConstr(x[0] + x[1] + x[3] <= 91)
    m.addConstr(x[0] + x[1] + x[2] + x[3] <= 91)
    m.addConstr(x[2] + x[3] <= 53)
    m.addConstr(8*x[0] + 3*x[3] <= 93)
    m.addConstr(8*x[0] + x[2] <= 102)
    m.addConstr(8*x[0] + 13*x[1] + x[2] + 3*x[3] <= 102)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
