
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="cucumber_vines", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="carrots", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name="vincas", vtype=gurobi.GRB.INTEGER)
x4 = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(6 * x1 + 8 * x2 + 2 * x3 + x4, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 == 1, name="cucumber_vines_yield")
model.addConstr(x1 + 14 * x3 + 13 * x4 >= 24, name="total_yield_cucumber_vincas_roses")
model.addConstr(x1 + 16 * x2 + 14 * x3 >= 24, name="total_yield_cucumber_carrots_vincas")
model.addConstr(x1 + 14 * x3 + 13 * x4 >= 18, name="total_yield_cucumber_vincas_roses_min")
model.addConstr(x1 + 16 * x2 + 14 * x3 >= 18, name="total_yield_cucumber_carrots_vincas_min")
model.addConstr(x3 + 3 * x4 >= 34, name="beauty_rating_vincas_roses")
model.addConstr(8 * x1 + x3 >= 35, name="beauty_rating_cucumber_vincas")
model.addConstr(13 * x2 + 3 * x4 >= 30, name="beauty_rating_carrots_roses")
model.addConstr(8 * x1 + 3 * x4 >= 22, name="beauty_rating_cucumber_roses")
model.addConstr(8 * x1 + 13 * x2 + x3 >= 34, name="beauty_rating_cucumber_carrots_vincas")
model.addConstr(x1 + 14 * x3 <= 81, name="yield_cucumber_vincas_max")
model.addConstr(16 * x2 + 14 * x3 <= 107, name="yield_carrots_vincas_max")
model.addConstr(16 * x2 + 13 * x4 <= 99, name="yield_carrots_roses_max")
model.addConstr(x1 + 13 * x4 <= 141, name="yield_cucumber_roses_max")
model.addConstr(14 * x3 + 13 * x4 <= 68, name="yield_vincas_roses_max")
model.addConstr(x1 + 16 * x2 <= 60, name="yield_cucumber_carrots_max")
model.addConstr(x1 + 16 * x2 + 13 * x4 <= 91, name="yield_cucumber_carrots_roses_max")
model.addConstr(x1 + 16 * x2 + 14 * x3 + 13 * x4 <= 91, name="total_yield_max")
model.addConstr(x3 + 3 * x4 <= 53, name="beauty_rating_vincas_roses_max")
model.addConstr(8 * x1 + 3 * x4 <= 93, name="beauty_rating_cucumber_roses_max")
model.addConstr(8 * x1 + x3 <= 102, name="beauty_rating_cucumber_vincas_max")
model.addConstr(8 * x1 + 13 * x2 + x3 + 3 * x4 <= 102, name="total_beauty_rating_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Cucumber Vines: ", x1.varValue)
    print("Carrots: ", x2.varValue)
    print("Vincas: ", x3.varValue)
    print("Roses: ", x4.varValue)
else:
    print("The model is infeasible")
