
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")
x5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x5")


# Set objective function
m.setObjective(6*x0*x1 + 2*x0*x2 + 7*x0*x5 + 3*x1*x2 + 3*x1*x4 + 9*x2*x4 + 2*x2*x5 + 6*x3**2 + 4*x3*x4 + 5*x0 + 9*x3 + 5*x5, gp.GRB.MAXIMIZE)

# Add constraints
constraints_json = {
    # ... (Insert the constraints from the JSON "constraints" field here)
}


for constraint_str in constraints_json:
    m.addConstr(eval(constraint_str))

# Resource constraints
m.addConstr(12 * x0 <= 177)
m.addConstr(11 * x1 <= 177)
m.addConstr(12 * x2 <= 177)
m.addConstr(6 * x3 <= 177)
m.addConstr(13 * x4 <= 177)
m.addConstr(10 * x5 <= 177)

m.addConstr(14 * x0 <= 312)
m.addConstr(12 * x1 <= 312)
m.addConstr(11 * x2 <= 312)
m.addConstr(6 * x3 <= 312)
m.addConstr(12 * x4 <= 312)
m.addConstr(12 * x5 <= 312)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

