
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # hours worked by Laura
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # hours worked by Bobby
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")  # hours worked by Jean


    # Set objective function
    model.setObjective(8*x0**2 + 6*x2**2 + x0, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*x1**2 + 7*x2**2 >= 25, "c0")
    model.addConstr(12*x0 + 6*x1 >= 21, "c1")
    model.addConstr(12*x0**2 + 6*x1**2 + 7*x2**2 >= 54, "c2")
    model.addConstr(12*x0 + 6*x1 + 7*x2 >= 54, "c3")
    model.addConstr(6*x0 + 16*x1 >= 40, "c4")
    model.addConstr(16*x1 + 8*x2 >= 98, "c5")
    model.addConstr(6*x0 + 16*x1 + 8*x2 >= 98, "c6")
    model.addConstr(4*x0**2 - 4*x2**2 >= 0, "c7")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
