
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Laura")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Bobby")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Jean")

    # Objective function
    model.setObjective(8*x0**2 + 6*x2**2 + x0, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(12*x0 <= 169)
    model.addConstr(6*x0 <= 294)
    model.addConstr(6*x1 <= 169)
    model.addConstr(16*x1 <= 294)
    model.addConstr(7*x2 <= 169)
    model.addConstr(8*x2 <= 294)
    model.addConstr(6*x1**2 + 7*x2**2 >= 25)
    model.addConstr(12*x0 + 6*x1 >= 21)
    model.addConstr(12*x0 + 6*x1 + 7*x2 >= 54)
    model.addConstr(6*x0 + 16*x1 >= 40)
    model.addConstr(16*x1 + 8*x2 >= 98)
    model.addConstr(6*x0 + 16*x1 + 8*x2 >= 98)
    model.addConstr(4*x0**2 - 4*x2**2 >= 0)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
