
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Laura
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Dale
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by John


    # Set objective function
    m.setObjective(3.01*x0 + 8.33*x1 + 4.51*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 7*x1 >= 4, "c0")
    m.addConstr(13*x0 + 7*x1 + 8*x2 >= 4, "c1")
    m.addConstr(14*x0 + 3*x1 >= 15, "c2")
    m.addConstr(3*x1 + 14*x2 >= 11, "c3")
    m.addConstr(14*x0 + 3*x1 + 14*x2 >= 19, "c4")
    m.addConstr(5*x0 + 14*x1 >= 17, "c5")
    m.addConstr(5*x0 + 14*x1 + 5*x2 >= 9, "c6")
    m.addConstr(-9*x0 + x2 >= 0, "c7")
    m.addConstr(8*x1 - x2 >= 0, "c8")
    m.addConstr(8*x0 - 4*x1 >= 0, "c9")
    m.addConstr(13*x0 + 8*x2 <= 30, "c10")
    m.addConstr(13*x0 + 7*x1 <= 41, "c11")
    m.addConstr(13*x0 + 7*x1 + 8*x2 <= 42, "c12")
    m.addConstr(14*x1 + 5*x2 <= 33, "c13")
    m.addConstr(5*x0 + 5*x2 <= 39, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
