
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Laura", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="hours_worked_by_Dale", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="hours_worked_by_John", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(3.01*x0 + 8.33*x1 + 4.51*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(13*x0 <= 44)
    model.addConstr(14*x0 <= 72)
    model.addConstr(5*x0 <= 59)
    model.addConstr(7*x1 <= 44)
    model.addConstr(3*x1 <= 72)
    model.addConstr(14*x1 <= 59)
    model.addConstr(8*x2 <= 44)
    model.addConstr(14*x2 <= 72)
    model.addConstr(5*x2 <= 59)
    model.addConstr(13*x0 + 7*x1 >= 4)
    model.addConstr(13*x0 + 7*x1 + 8*x2 >= 4)
    model.addConstr(14*x0 + 3*x1 >= 15)
    model.addConstr(3*x1 + 14*x2 >= 11)
    model.addConstr(14*x0 + 3*x1 + 14*x2 >= 19)
    model.addConstr(5*x0 + 14*x1 >= 17)
    model.addConstr(5*x0 + 14*x1 + 5*x2 >= 9)
    model.addConstr(-9*x0 + x2 >= 0)
    model.addConstr(8*x1 - x2 >= 0)
    model.addConstr(8*x0 - 4*x1 >= 0)
    model.addConstr(13*x0 + 8*x2 <= 30)
    model.addConstr(13*x0 + 7*x1 <= 41)
    model.addConstr(13*x0 + 7*x1 + 8*x2 <= 42)
    model.addConstr(14*x1 + 5*x2 <= 33)
    model.addConstr(5*x0 + 5*x2 <= 39)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Dale: ", x1.varValue)
        print("Hours worked by John: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
