
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")


    # Set objective function
    m.setObjective(9*x0 + 7*x1 + 1*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.03*x0 + 0.14*x2 >= 47, "c1")
    m.addConstr(0.93*x1 + 0.14*x2 >= 61, "c2")
    m.addConstr(0.03*x0 + 0.93*x1 >= 92, "c3")
    m.addConstr(0.03*x0 + 0.93*x1 + 0.14*x2 >= 79, "c4")
    m.addConstr(0.93*x1 + 0.14*x2 <= 185, "c5")
    m.addConstr(0.03*x0 + 0.14*x2 <= 145, "c6")
    m.addConstr(0.03*x0 + 0.93*x1 <= 163, "c7")
    m.addConstr(0.03*x0 + 0.93*x1 + 0.14*x2 <= 163, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('corn_cobs:', x0.x)
        print('strawberries:', x1.x)
        print('milkshakes:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
