
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="corn_cobs", lb=0)  # No upper bound given
    x2 = model.addVar(name="strawberries", lb=0)  # No upper bound given
    x3 = model.addVar(name="milkshakes", lb=0)  # No upper bound given

    # Define the objective function
    model.setObjective(9 * x1 + 7 * x2 + x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.03 * x1 + 0.14 * x3 >= 47)
    model.addConstr(0.93 * x2 + 0.14 * x3 >= 61)
    model.addConstr(0.03 * x1 + 0.93 * x2 >= 92)
    model.addConstr(0.03 * x1 + 0.93 * x2 + 0.14 * x3 >= 79)
    model.addConstr(0.93 * x2 + 0.14 * x3 <= 185)
    model.addConstr(0.03 * x1 + 0.14 * x3 <= 145)
    model.addConstr(0.03 * x1 + 0.93 * x2 <= 163)
    model.addConstr(0.03 * x1 + 0.93 * x2 + 0.14 * x3 <= 163)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Corn cobs: {x1.varValue}")
        print(f"Strawberries: {x2.varValue}")
        print(f"Milkshakes: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
