
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")

# Set objective function
m.setObjective(6*green_beans + 6*cherry_pies + 4*fruit_salads + 1*kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14*cherry_pies + 12*kiwis >= 34)
m.addConstr(1*green_beans + 14*cherry_pies >= 40)
m.addConstr(1*green_beans + 5*fruit_salads >= 78)
m.addConstr(1*green_beans + 12*kiwis >= 62)
m.addConstr(1*green_beans + 14*cherry_pies + 5*fruit_salads + 12*kiwis >= 62)
m.addConstr(14*fruit_salads + 7*kiwis >= 34)
m.addConstr(12*cherry_pies + 7*kiwis >= 35)
m.addConstr(12*cherry_pies + 14*fruit_salads + 7*kiwis >= 34)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads >= 34)
m.addConstr(5*green_beans + 12*cherry_pies + 7*kiwis >= 34)
m.addConstr(5*green_beans + 14*fruit_salads + 7*kiwis >= 34)
m.addConstr(12*cherry_pies + 14*fruit_salads + 7*kiwis >= 39)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads >= 39)
m.addConstr(5*green_beans + 12*cherry_pies + 7*kiwis >= 39)
m.addConstr(5*green_beans + 14*fruit_salads + 7*kiwis >= 39)
m.addConstr(12*cherry_pies + 14*fruit_salads + 7*kiwis >= 23)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads >= 23)
m.addConstr(5*green_beans + 12*cherry_pies + 7*kiwis >= 23)
m.addConstr(5*green_beans + 14*fruit_salads + 7*kiwis >= 23)
m.addConstr(12*cherry_pies + 14*fruit_salads + 7*kiwis >= 36)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads >= 36)
m.addConstr(5*green_beans + 12*cherry_pies + 7*kiwis >= 36)
m.addConstr(5*green_beans + 14*fruit_salads + 7*kiwis >= 36)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads + 7*kiwis >= 36)
m.addConstr(-10*green_beans + 6*fruit_salads >= 0)
m.addConstr(-4*green_beans + 8*cherry_pies >= 0)
m.addConstr(5*fruit_salads + 12*kiwis <= 142)
m.addConstr(1*green_beans + 5*fruit_salads <= 294)
m.addConstr(14*cherry_pies + 12*kiwis <= 277)
m.addConstr(1*green_beans + 14*cherry_pies <= 230)
m.addConstr(1*green_beans + 14*cherry_pies + 12*kiwis <= 184)
m.addConstr(1*green_beans + 5*fruit_salads + 12*kiwis <= 270)
m.addConstr(12*cherry_pies + 14*fruit_salads <= 58)
m.addConstr(5*green_beans + 14*fruit_salads + 7*kiwis <= 45)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads <= 79)
m.addConstr(5*green_beans + 12*cherry_pies + 7*kiwis <= 63)
m.addConstr(1*green_beans + 14*cherry_pies + 5*fruit_salads + 12*kiwis <= 339)
m.addConstr(5*green_beans + 12*cherry_pies + 14*fruit_salads + 7*kiwis <= 162)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

