
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # green beans
    x1 = model.addVar(name="x1", lb=0)  # cherry pies
    x2 = model.addVar(name="x2", lb=0)  # fruit salads
    x3 = model.addVar(name="x3", lb=0)  # kiwis

    # Define the objective function
    model.setObjective(6 * x0 + 6 * x1 + 4 * x2 + x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 12 * x3 >= 34)
    model.addConstr(x0 + 14 * x1 >= 40)
    model.addConstr(x0 + 5 * x2 >= 78)
    model.addConstr(x0 + 12 * x3 >= 62)
    model.addConstr(x0 + 14 * x1 + 5 * x2 + 12 * x3 >= 62)
    model.addConstr(12 * x2 + 7 * x3 >= 34)
    model.addConstr(12 * x1 + 7 * x3 >= 35)
    model.addConstr(12 * x1 + 14 * x2 + 7 * x3 >= 34)
    model.addConstr(5 * x0 + 12 * x1 + 14 * x2 >= 34)
    model.addConstr(5 * x0 + 12 * x1 + 7 * x3 >= 34)
    model.addConstr(5 * x0 + 14 * x2 + 7 * x3 >= 34)
    model.addConstr(12 * x1 + 14 * x2 + 7 * x3 >= 39)
    model.addConstr(5 * x0 + 12 * x1 + 14 * x2 >= 39)
    model.addConstr(5 * x0 + 12 * x1 + 7 * x3 >= 39)
    model.addConstr(5 * x0 + 14 * x2 + 7 * x3 >= 39)
    model.addConstr(12 * x1 + 14 * x2 + 7 * x3 >= 23)
    model.addConstr(5 * x0 + 12 * x1 + 14 * x2 >= 23)
    model.addConstr(5 * x0 + 12 * x1 + 7 * x3 >= 23)
    model.addConstr(5 * x0 + 14 * x2 + 7 * x3 >= 23)
    model.addConstr(12 * x1 + 14 * x2 + 7 * x3 >= 36)
    model.addConstr(5 * x0 + 12 * x1 + 14 * x2 >= 36)
    model.addConstr(5 * x0 + 12 * x1 + 7 * x3 >= 36)
    model.addConstr(5 * x0 + 14 * x2 + 7 * x3 >= 36)
    model.addConstr(5 * x0 + 12 * x1 + 14 * x2 + 7 * x3 >= 36)
    model.addConstr(-10 * x0 + 6 * x2 >= 0)
    model.addConstr(-4 * x0 + 8 * x1 >= 0)
    model.addConstr(5 * x2 + 12 * x3 <= 142)
    model.addConstr(x0 + 5 * x2 <= 294)
    model.addConstr(14 * x1 + 12 * x3 <= 277)
    model.addConstr(x0 + 14 * x1 <= 230)
    model.addConstr(x0 + 14 * x1 + 12 * x3 <= 184)
    model.addConstr(x0 + 5 * x2 + 12 * x3 <= 270)
    model.addConstr(12 * x1 + 14 * x2 <= 58)
    model.addConstr(5 * x0 + 14 * x2 + 7 * x3 <= 45)
    model.addConstr(5 * x0 + 12 * x1 + 14 * x2 <= 79)
    model.addConstr(5 * x0 + 12 * x1 + 7 * x3 <= 63)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0 (green beans): {x0.varValue}")
        print(f"x1 (cherry pies): {x1.varValue}")
        print(f"x2 (fruit salads): {x2.varValue}")
        print(f"x3 (kiwis): {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
